package org.msh.tb.reports2.variables;

import org.msh.reports.keys.Key;
import org.msh.tb.entities.AgeRange;
import org.msh.tb.reports2.ReportResources;
import org.msh.tb.reports2.VariableImpl;

/**
 * Created by rmemoria on 9/12/16.
 */
public class AgeRange2Variable extends VariableImpl {

    public static final int AGE_0TO4 = 1;
    public static final int AGE_5TO14 = 2;
    public static final int AGE_OVER15 = 3;


    public AgeRange2Variable() {
        super(ReportResources.VAR_AGERANGE2, "TbCase.age", "tbcase.age");
    }

    /* (non-Javadoc)
     * @see org.msh.tb.reports2.VariableImpl#createKey(java.lang.Object)
     */
    @Override
    public Key createKey(Object values, int iteration) {
        if (values == null) {
            return Key.asNull();
        }

        // get the age
        int age = (Integer)values;

        if (age <= 4) {
            return Key.of(AGE_0TO4);
        }

        if (age <= 14) {
            return Key.of(AGE_5TO14);
        }

        return Key.of(AGE_OVER15);
    }

    @Override
    public String getDisplayText(Key key) {
        // if it's null, return undefined
        if (key.isNull()) {
            return super.getDisplayText(key);
        }

        switch ((Integer)key.getValue()) {
            case AGE_0TO4: return "0-4";
            case AGE_5TO14: return "5-14";
            default: return "≥ 15";
        }
    }

    @Override
    public int compareValues(Key key1, Key key2) {
        Integer val1 = (Integer)key1.getValue();
        Integer val2 = (Integer)key2.getValue();

        if (val1 == val2) {
            return 0;
        }

        if (val1 != null && val2 != null) {
            return ((Integer)val1).compareTo((Integer)val2);
        }

        return super.compareValues(key1, key2);
    }
}
